package parser.visitor;

import parser.*;

/**
 * Abstract algo to check the tags in an XML expression. 
 * Defines the algo to return a boolean and take an Object as its input parameters.
 * Sets the default case to return false.
 */
public abstract class ACheckTagsAlgo<P> implements IGramTypeVisitor<Boolean, P> {
  public Boolean mtCase(MTSymbol host, P... inps) {
    System.err.println("ACheckTagsAlgo: mtCase called");
    return false;
  }
  
  public Boolean termCase(TerminalSymbol host, P... inps){
    System.err.println("ACheckTagsAlgo: termCase called with host= "+host);
    return false;
  }
  
  public Boolean seqCase(SequenceSymbol host, P... inps) { 
    System.err.println("ACheckTagsAlgo: seqCase called with host= "+host);
    Thread.dumpStack();
    return false;
  }  
}